import sys
import bisect
from collections import defaultdict

input = sys.stdin.readline

N, Q = map(int, input().split())
a = list(map(int, input().split()))

cnt = defaultdict(int)
for x in a:
    cnt[x] += 1

total_sum = sum(a)

vals = []
for v, c in cnt.items():
    vals.append(v * c)
vals.sort()

def remove_val(x):
    global total_sum
    v = a[x]
    old = v * cnt[v]
    pos = bisect.bisect_left(vals, old)
    vals.pop(pos)

    cnt[v] -= 1
    total_sum -= v

    if cnt[v] > 0:
        new = v * cnt[v]
        bisect.insort(vals, new)

def add_val(x, v):
    global total_sum
    if cnt[v] > 0:
        old = v * cnt[v]
        pos = bisect.bisect_left(vals, old)
        vals.pop(pos)

    cnt[v] += 1
    total_sum += v
    new = v * cnt[v]
    bisect.insort(vals, new)
    a[x] = v

for _ in range(Q):
    q = input().split()
    if q[0] == '1':
        k = int(q[1])
        m = N - k
        if m <= 0:
            print(total_sum)
        else:
            s = 0
            for i in range(1, m + 1):
                if i > len(vals):
                    break
                s += vals[-i]
            print(total_sum - s)
    else:
        x = int(q[1]) - 1
        y = int(q[2])
        remove_val(x)
        add_val(x, y)